/****** Object:  StoredProcedure [dbo].[P_EST_NF_SAI_IT_REPROCESSAR_CUSTO]    Script Date: 09/25/2013 16:30:59 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_NF_SAI_IT_REPROCESSAR_CUSTO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_NF_SAI_IT_REPROCESSAR_CUSTO]
GO
GO
GO
--EXEC P_EST_NF_SAI_IT_REPROCESSAR_CUSTO 7,2015,99,0
CREATE PROCEDURE [dbo].[P_EST_NF_SAI_IT_REPROCESSAR_CUSTO]( @MES INT=NULL, 
														@ANO INT=NULL,
														@CD_FILIAL_PAR INT=0,
														@TIPO_CUSTO INT=0,
														@DT_PROC DATETIME=NULL,
														@CD_PROD INT=0)  WITH ENCRYPTION AS
	
	DECLARE @DT_INI DATETIME
	DECLARE @DT_FIM DATETIME
	DECLARE @DIA DATETIME
	DECLARE @CD_FILIAL AS INT
	DECLARE @AGORA DATETIME
	DECLARE @Inicial INT=0
	DECLARE @DT_LIMITE DATETIME

	DECLARE @NaoUtilizaCustoGerTransf Tinyint=0;


	--Rodar ate hoje
	SET @DT_LIMITE =(  SELECT CONVERT(VARCHAR,GETDATE(),112));
/*****************************************************************************************************************************/
--Configuração para custo inicial dia venda..
/*****************************************************************************************************************************/
	IF @TIPO_CUSTO = 0 
	begin 
		IF ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_EMP=1 AND CD_CHAVE= 'CUSTO_MEDIO_INICIO_DIA_VENDAS'),0)=1
		BEGIN
			set @Inicial= 10;
		END
	end
/*****************************************************************************************************************************/
	SET NOCOUNT ON
	IF  @DT_PROC IS NULL
		begin
			IF @ANO IS NULL OR @MES IS NULL
				begin
					SELECT @AGORA=DATEADD(month, -1, GETDATE()), @ANO=YEAR(@AGORA), @MES=MONTH(@AGORA)
				end
			
			SET @DT_INI = CONVERT(DATETIME, (CONVERT(VARCHAR, (@ANO*100+@MES)) + '01')) ;
			SET @DT_FIM = dbo.F_FINAL_MES (@DT_INI) ;
		end
		
	IF  NOT @DT_PROC IS NULL
		begin
			SET @DT_INI = @DT_PROC;
			SET @DT_FIM = @DT_PROC;
		end
			
	--Roda so ate hoje
	IF  @DT_FIM > @DT_LIMITE
	BEGIN
		SET @DT_FIM = @DT_LIMITE
	END

	Set @NaoUtilizaCustoGerTransf = ISNULL ((SELECT VALOR FROM PRC_EMP_CONFIG WHERE CD_CHAVE = 'NAO_CONTROLA_CUSTO_GERENCIAL_TRANSF'),0)
    
/*************************************************************************************************/
 
IF  OBJECT_ID('TEMPDB.DBO.#RsProdNf') IS NOT NULL
	BEGIN
		 DROP TABLE #RsProdNf
	END
	 
	CREATE TABLE #RsProdNf(CD_EMP INT,
								CD_FILIAL INT,
								CD_PROD INT )  

/*************************************************************************************************/

	DECLARE @NMTBL VARCHAR(100), @CMD VARCHAR(500);
	SET @NMTBL = 'EST_FECHA_PROC_MOV_PEND_TBL_PROC_' +CONVERT(VARCHAR,@CD_FILIAL_PAR);

	IF NOT OBJECT_ID(@NMTBL) IS NULL
	BEGIN 
		SET @CMD = 'INSERT INTO #RsProdNf(CD_EMP, CD_FILIAL, CD_PROD)
					SELECT  DISTINCT CD_EMP, CD_FILIAL, CD_PROD
					FROM ' + @NMTBL + ' WHERE CD_EMP=1 '  
		SET @CMD = @CMD+ 'AND CD_FILIAL =' + convert(varchar,@CD_FILIAL_PAR) 
		
		IF NOT @DT_PROC  IS NULL
			SET @CMD = @CMD+ ' AND DT_PROC =''' + convert(varchar,@DT_PROC,112)  + ''''
			
		EXEC (@CMD);
	END 

	IF @CD_PROD > 0 
	BEGIN
		delete from #RsProdNf
		INSERT INTO #RsProdNf(CD_EMP, CD_FILIAL, CD_PROD)
		SELECT 1, @CD_FILIAL_PAR, @CD_PROD
	END 

	if not exists(select top 1 cd_emp from #RsProdNf)
	begin
		INSERT INTO #RsProdNf(CD_EMP, CD_FILIAL, CD_PROD)
		SELECT DISTINCT CD_EMP, CD_FILIAL, CD_PROD
		FROM 
			EST_NF_SAI_IT
		WHERE
			EST_NF_SAI_IT.CD_EMP = 1 
			AND EST_NF_SAI_IT.CD_FILIAL  = CASE WHEN @CD_FILIAL_PAR = 0 THEN CD_FILIAL ELSE @CD_FILIAL_PAR END
			AND EST_NF_SAI_IT.DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM
	end
	
	CREATE CLUSTERED INDEX IX_#RsProdNf ON #RsProdNf (CD_PROD,CD_FILIAL,CD_EMP) ;
/*************************************************************************************************/
	PRINT 'Custo do movimento de nota fiscal saida  ' + CONVERT(VARCHAR, GETDATE (),108)
	
	DECLARE cFilialNf CURSOR FAST_FORWARD READ_ONLY FOR 
	SELECT  
	 	CD_FILIAL
	FROM 
		PRC_FILIAL
	WHERE 
		CD_EMP = 1  
		AND CD_FILIAL = CASE WHEN @CD_FILIAL_PAR = 0 THEN CD_FILIAL ELSE @CD_FILIAL_PAR END
	OPEN cFilialNf
	FETCH NEXT FROM cFilialNf INTO @CD_FILIAL

	WHILE @@FETCH_STATUS=0
	BEGIN
		SET @DIA = @DT_INI
		WHILE @DT_FIM >= @DIA
			BEGIN

				PRINT 'Filial ' + CONVERT(VARCHAR, @CD_FILIAL) + ' -  Processando dia  ' + CONVERT(VARCHAR, @DIA, 112) + ' ' + CONVERT(VARCHAR, GETDATE (),108)
				IF @TIPO_CUSTO = 0 
					begin
						UPDATE
							I
						SET 
							VLR_CUSTO_MD = dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (I.CD_EMP,I.CD_FILIAL,I.CD_PROD,I.DT_EMI_NF,@Inicial),
							VLR_CUSTO_GERENCIAL_TRANSF =Case When @NaoUtilizaCustoGerTransf = 0 then	
															 dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (I.CD_EMP,I.CD_FILIAL,I.CD_PROD,I.DT_EMI_NF,1)
															 else  dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (I.CD_EMP,I.CD_FILIAL,I.CD_PROD,I.DT_EMI_NF,@Inicial) end
						FROM 
							EST_NF_SAI_IT I
							inner join #RsProdNf p on 
							i.cd_emp=p.cd_emp and
							i.cd_prod  =p.cd_prod  and
							i.cd_filial=p.cd_filial
						 WHERE
							I.CD_EMP = 1 
							AND I.CD_FILIAL = @CD_FILIAL 
							AND I.DT_EMI_NF = @DIA 
					end					
				
				IF @TIPO_CUSTO = 1 
					begin
						UPDATE
							i
						SET 
							VLR_CUSTO_MD			   = dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (i.CD_EMP,i.CD_FILIAL,i.CD_PROD,i.DT_EMI_NF,2),
							VLR_CUSTO_GERENCIAL_TRANSF = Case When @NaoUtilizaCustoGerTransf = 0 then	
																	dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (i.CD_EMP,i.CD_FILIAL,i.CD_PROD,i.DT_EMI_NF, 7)
															else dbo.F_VLR_CUSTO_EST_FECHA_PROC_MOV (i.CD_EMP,i.CD_FILIAL,i.CD_PROD,i.DT_EMI_NF,2) end
						FROM 
							EST_NF_SAI_IT I
							inner join #RsProdNf p on 
							i.cd_emp=p.cd_emp and
							i.cd_prod  =p.cd_prod  and
							i.cd_filial=p.cd_filial
						 WHERE
							i.CD_EMP = 1 
							AND i.CD_FILIAL = @CD_FILIAL 
							AND i.DT_EMI_NF = @DIA
							--AND EST_NF_SAI_IT.CD_PROD = CASE WHEN @CD_PROD>0 THEN @CD_PROD ELSE EST_NF_SAI_IT.CD_PROD END		
					end					

				SELECT @DIA = @DIA + 1
			END		
		FETCH NEXT FROM  cFilialNf INTO @CD_FILIAL 
	END
CLOSE cFilialNf
DEALLOCATE cFilialNf

